/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.apple.eio.FileManager;
import com.sun.deploy.Environment;
import com.sun.deploy.config.AutoUpdater;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.DefaultConfig;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.MacOSXAutoUpdater;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.IconEncoder;
import com.sun.deploy.util.MacIconEncoder;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacOSXPlatform
extends Platform {
    private String _userHome;
    private String _systemHome;
    private String _osHome;
    private static String ORACLE_JAVA_DEPLOYMENT = "Oracle" + File.separator + "Java" + File.separator + "Deployment";
    private static final int[] DEFAULT_SIZES = new int[]{512, 256, 128, 32, 16};

    public MacOSXPlatform() {
        this.loadDeployNativeLib();
    }

    public native void loadJRS();

    private native void setNativeJVM();

    @Override
    public void loadDeployNativeLib() {
        try {
            System.load(Environment.getJavaHome() + File.separator + "lib" + File.separator + "libdeploy.dylib");
            this.setNativeJVM();
            this.loadJRS();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    @Override
    public synchronized AutoUpdater getAutoUpdater() {
        if (this.auInstance == null) {
            this.auInstance = new MacOSXAutoUpdater();
        }
        return this.auInstance;
    }

    @Override
    public synchronized IconEncoder getIconEncoder() {
        if (this.ieInstance == null) {
            this.ieInstance = new MacIconEncoder();
        }
        return this.ieInstance;
    }

    @Override
    public String getPlatformIconType() {
        return "icns";
    }

    @Override
    public void addRemoveProgramsAdd(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
    }

    @Override
    public void addRemoveProgramsRemove(String string, boolean bl) {
    }

    @Override
    public boolean canAutoDownloadJRE() {
        return false;
    }

    @Override
    public boolean canUseAlternateJREs() {
        return false;
    }

    @Override
    public String getBrowserPath() {
        return null;
    }

    @Override
    public String getBrowserHomePath() {
        return null;
    }

    @Override
    public String getDefaultSystemCache() {
        return null;
    }

    @Override
    public String getFireFoxUserProfileDirectory() {
        return null;
    }

    @Override
    public boolean canBecomeAdmin() {
        return true;
    }

    @Override
    public boolean hasAdminPrivileges() {
        return false;
    }

    @Override
    public List<JREInfo> getInstalledJREList() {
        ArrayList<JREInfo> arrayList = new ArrayList<JREInfo>();
        JREInfo jREInfo = new JREInfo(null, System.getProperty("java.version"), null, Environment.getJavaHome(), "", Config.getOSName(), Config.getOSArch(), true, true);
        arrayList.add(jREInfo);
        return arrayList;
    }

    @Override
    public String getMozillaUserProfileDirectory() {
        return null;
    }

    @Override
    public native long getNativePID();

    @Override
    public String getSessionSpecificString() {
        return "";
    }

    @Override
    public String getSystemJavawsPath() {
        return Environment.getJavawsCommand();
    }

    @Override
    public int[] getIconSizes() {
        return DEFAULT_SIZES;
    }

    @Override
    public int getSystemShortcutIconSize(boolean bl) {
        return 128;
    }

    @Override
    public int installShortcut(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return 0;
    }

    @Override
    public int updateShortcut(String string, String string2) {
        return 0;
    }

    @Override
    public String getShortcutJnlpName(String string) {
        return null;
    }

    @Override
    public boolean isBrowserFireFox() {
        return false;
    }

    @Override
    public boolean isLocalInstallSupported() {
        return true;
    }

    @Override
    public boolean isNativeModalDialogUp() {
        return false;
    }

    @Override
    public boolean isPlatformIconType(String string) {
        return string.toLowerCase().endsWith(".icns");
    }

    @Override
    public String getRoamingUserHome() {
        return null;
    }

    @Override
    public boolean isPlatformWindowsVista() {
        return false;
    }

    @Override
    public void sendJFXPing(String string, String string2, String string3, String string4, String string5, int n, String string6) {
    }

    @Override
    public void setUserHomeOverride(String string) {
    }

    static boolean doShowDocument(final URL uRL) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    FileManager.openURL((String)uRL.toString());
                    return Boolean.TRUE;
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                    return Boolean.FALSE;
                }
            }
        });
        return bl;
    }

    @Override
    public boolean showDocument(String string) {
        if (!MacOSXPlatform.isArgumentOkay(string)) {
            return false;
        }
        try {
            return MacOSXPlatform.doShowDocument(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
            return false;
        }
    }

    @Override
    public boolean getJavaPluginSettings() {
        return true;
    }

    @Override
    public int setJavaPluginSettings(boolean bl) {
        return 2;
    }

    @Override
    public void initBrowserSettings() {
    }

    @Override
    public int applyBrowserSettings() {
        return 0;
    }

    @Override
    public boolean systemLookAndFeelDefault() {
        return true;
    }

    @Override
    public String getUserHome() {
        if (this._userHome == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.user.profile"));
            if (string == null || string.trim().equals("")) {
                String string2 = this.nativeGetHome(true);
                string = string2 != null ? string2 : AccessController.doPrivileged(new GetPropertyAction("user.home"));
            }
            this._userHome = string + (string.endsWith(File.separator) ? "" : File.separator) + ORACLE_JAVA_DEPLOYMENT;
        }
        return this._userHome;
    }

    @Override
    public String getUserHomeOverride() {
        return null;
    }

    @Override
    public String getSystemHome() {
        if (this._systemHome == null) {
            this._systemHome = this.nativeGetHome(false) + File.separator + ORACLE_JAVA_DEPLOYMENT;
        }
        return this._systemHome;
    }

    @Override
    public String getOSHome() {
        if (this._osHome == null) {
            this._osHome = File.separator + "etc";
        }
        return this._osHome;
    }

    @Override
    public String getPlatformSpecificJavaName() {
        return "java";
    }

    @Override
    public String getPlatformExtension() {
        return "";
    }

    @Override
    public String getLibraryPrefix() {
        return "lib";
    }

    @Override
    public String getLibrarySufix() {
        return ".dylib";
    }

    @Override
    public String getDebugJavaPath(String string) {
        return string;
    }

    @Override
    public String getLongPathName(String string) {
        return string;
    }

    @Override
    public boolean updateJava(String string) {
        MacOSXAutoUpdater.callAutoUpdate(null);
        return true;
    }

    @Override
    public boolean samePaths(String string, String string2) {
        try {
            return new File(string).getCanonicalPath().equals(new File(string2).getCanonicalPath());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public native int getPlatformMaxCommandLineLength();

    @Override
    public boolean useAltFileSystemView() {
        return false;
    }

    @Override
    public String toExecArg(String string) {
        return string;
    }

    @Override
    public native void onLoad(Object var1);

    @Override
    public void onSave(Object object) {
    }

    @Override
    public boolean shouldPromptForAutoCheck() {
        return false;
    }

    @Override
    public void handleUserResponse(int n) {
    }

    @Override
    public void resetJavaHome() {
    }

    @Override
    public String findSecureLauncher(File file) {
        return null;
    }

    @Override
    void setDefaultConfigProperties(DefaultConfig defaultConfig) {
        defaultConfig.setProperty("deployment.system.tray.icon", "false");
    }

    @Override
    public native String getLoadedNativeLibPath(String var1);

    @Override
    public void cacheSecurityBaseline(String string, String string2) {
    }

    private native String nativeGetHome(boolean var1);

    @Override
    public String getDefaultIconPath() {
        return this.nativeGetIconPath();
    }

    private native String nativeGetIconPath();

    @Override
    public void cacheCurrentConfig(Properties properties) {
        try {
            Preferences preferences = Preferences.userRoot().node("/com/oracle/javadeployment");
            preferences.clear();
            for (String string : properties.keySet()) {
                preferences.put(string, properties.getProperty(string));
            }
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            Trace.ignored(backingStoreException);
        }
    }

    public native boolean getAutoUpdateCheckEnabled();

    public native boolean setAutoUpdateCheckEnabled(boolean var1);

    @Override
    public Platform.WebJavaSwitch getWebJavaSwitch() {
        return MacOSXWebJavaSwitch.getInstance();
    }

    public static final class MacOSXWebJavaSwitch
    extends Platform.WebJavaSwitch {
        private static final String JAVA_APPLICATION_SUPPORT_INFO_PLIST_SYMLINK = "/Library/Application Support/Oracle/Java/Info.plist";
        private static final String JAVA_PLUGIN_ENABLED_INFO_PLIST = "/Library/Internet Plug-Ins/JavaAppletPlugin.plugin/Contents/Enabled.plist";
        private static MacOSXWebJavaSwitch _MacOSXWebJavaSwitch = new MacOSXWebJavaSwitch();

        private MacOSXWebJavaSwitch() {
        }

        public static MacOSXWebJavaSwitch getInstance() {
            return _MacOSXWebJavaSwitch;
        }

        protected void setSystemWebJavaEnabled(boolean bl) {
            if (bl != this.isSystemWebJavaEnabled()) {
                this.setNativeSystemWebJavaEnabled(bl);
            }
        }

        protected boolean isSystemWebJavaEnabled() {
            boolean bl = false;
            try {
                Path path;
                Path path2;
                Path path3 = new File(JAVA_APPLICATION_SUPPORT_INFO_PLIST_SYMLINK).toPath();
                if (Files.isSymbolicLink(path3) && Files.isSameFile(path2 = Files.readSymbolicLink(path3), path = new File(JAVA_PLUGIN_ENABLED_INFO_PLIST).toPath())) {
                    bl = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bl;
        }

        private native void setNativeSystemWebJavaEnabled(boolean var1);
    }
}

