/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.IconEncoder;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class MacIconEncoder
implements IconEncoder {
    public void convert(File[] fileArray, int[] nArray, int n, String string) {
        File file = fileArray[0];
        int n2 = nArray[0];
        for (int i = 0; i < n; ++i) {
            if (n2 >= nArray[i]) continue;
            n2 = nArray[i];
            file = fileArray[i];
        }
        String string2 = this.getImageFormat(file);
        if (string2 != null) {
            String string3 = file.getPath();
            Trace.println("Convert image: " + string3 + "->" + string, TraceLevel.TEMP);
            this.convert(string3, string2, string);
        }
    }

    private String getImageFormat(File file) {
        String string = null;
        try {
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            if (!iterator.hasNext()) {
                Trace.println("Warning: unable to get reader for image " + file, TraceLevel.TEMP);
                return null;
            }
            ImageReader imageReader = iterator.next();
            imageInputStream.close();
            if (imageReader == null || imageReader.getFormatName() == null) {
                return null;
            }
            string = imageReader.getFormatName().toLowerCase();
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
            return null;
        }
        if (!("gif".equals(string) || "jpeg".equals(string) || "jpg".equals(string) || "png".equals(string))) {
            Trace.println("Warning: unknown format " + string + " for image " + file, TraceLevel.TEMP);
            return null;
        }
        return string;
    }

    private native void convert(String var1, String var2, String var3);
}

